/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList
extends ArrayList {
    protected ArrayList list = null;
    protected boolean fast = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.fast) {
            int n = 1;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n = 31 * n + (e == null ? 0 : e.hashCode());
            }
            return n;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = 1;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n = 31 * n + (e == null ? 0 : e.hashCode());
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.size();
        }
    }

    public FastArrayList() {
        this.list = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.clear();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.trimToSize();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.trimToSize();
        }
    }

    public boolean getFast() {
        return this.fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.isEmpty();
        }
    }

    public FastArrayList(int n) {
        this.list = new ArrayList(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int n) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.ensureCapacity(n);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.ensureCapacity(n);
        }
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        FastArrayList fastArrayList = null;
        if (this.fast) {
            fastArrayList = new FastArrayList((Collection)this.list);
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                fastArrayList = new FastArrayList((Collection)this.list);
            }
        }
        fastArrayList.setFast(this.getFast());
        return fastArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        if (this.fast) {
            return this.list.get(n);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int n) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                Object e = arrayList.remove(n);
                this.list = arrayList;
                return e;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.add(n, object);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object object) {
        if (this.fast) {
            return this.list.indexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object object) {
        if (this.fast) {
            return this.list.lastIndexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.lastIndexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.add(object);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (this.fast) {
            return this.list.contains(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.fast) {
            ListIterator listIterator = this.list.listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                Object e = listIterator.next();
                Object e2 = listIterator2.next();
                if (e != null ? e.equals(e2) : e2 == null) continue;
                return false;
            }
            return !listIterator.hasNext() && !listIterator2.hasNext();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = this.list.listIterator();
            ListIterator listIterator3 = list.listIterator();
            while (listIterator.hasNext() && listIterator3.hasNext()) {
                Object e = listIterator.next();
                Object e3 = listIterator3.next();
                if (e != null ? e.equals(e3) : e3 == null) continue;
                return false;
            }
            return !listIterator.hasNext() && !listIterator3.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.remove(object);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(object);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FastArrayList[");
        stringBuffer.append(this.list.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(n, collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(n, collection);
        }
    }

    public FastArrayList(Collection collection) {
        this.list = new ArrayList(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.removeAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.removeAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.retainAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.retainAll(collection);
        }
    }

    public Iterator iterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return this.list.iterator();
    }

    public List subList(int n, int n2) {
        if (this.fast) {
            return new SubList(n, n2);
        }
        return this.list.subList(n, n2);
    }

    public ListIterator listIterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return this.list.listIterator();
    }

    public ListIterator listIterator(int n) {
        if (this.fast) {
            return new ListIter(n);
        }
        return this.list.listIterator(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int n, Object object) {
        if (this.fast) {
            return this.list.set(n, object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.set(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        if (this.fast) {
            return this.list.toArray(objectArray);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray(objectArray);
        }
    }

    private class ListIter
    implements ListIterator {
        private List expected;
        private ListIterator iter;
        private int lastReturnedIndex = -1;

        public int nextIndex() {
            this.checkMod();
            return this.iter.nextIndex();
        }

        public int previousIndex() {
            this.checkMod();
            return this.iter.previousIndex();
        }

        private void checkMod() {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().remove(this.lastReturnedIndex);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.previousIndex());
            this.lastReturnedIndex = -1;
        }

        public boolean hasNext() {
            this.checkMod();
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            this.checkMod();
            return this.iter.hasPrevious();
        }

        public Object next() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.nextIndex();
            return this.iter.next();
        }

        public Object previous() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.previousIndex();
            return this.iter.previous();
        }

        public void add(Object object) {
            this.checkMod();
            int n = this.nextIndex();
            this.get().add(n, object);
            this.iter = this.get().listIterator(n + 1);
            this.lastReturnedIndex = 1;
        }

        public void set(Object object) {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().set(this.lastReturnedIndex, object);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.previousIndex() + 1);
        }

        List get() {
            return this.expected;
        }

        public ListIter(int n) {
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(n);
        }
    }

    private class SubList
    implements List {
        private int first;
        private int last;
        private List expected;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).hashCode();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).size();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    this.get(arrayList).clear();
                    this.last = this.first;
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).isEmpty();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int n) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).get(n);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int n) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    Object e = this.get(arrayList).remove(n);
                    --this.last;
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    return e;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).remove(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int n, Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    this.get(arrayList).add(n, object);
                    ++this.last;
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).add(n, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object object) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).indexOf(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object object) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).lastIndexOf(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).add(object);
                    if (bl) {
                        ++this.last;
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).contains(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (FastArrayList.this.fast) {
                return this.get(this.expected).equals(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).remove(object);
                    if (bl) {
                        --this.last;
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int n, Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).addAll(n, collection);
                    FastArrayList.this.list = arrayList;
                    if (bl) {
                        this.last += collection.size();
                    }
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).addAll(n, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).addAll(collection);
                    if (bl) {
                        this.last += collection.size();
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection collection) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).containsAll(collection);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    List list = this.get(arrayList);
                    boolean bl = list.removeAll(collection);
                    if (bl) {
                        this.last = this.first + list.size();
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    List list = this.get(arrayList);
                    boolean bl = list.retainAll(collection);
                    if (bl) {
                        this.last = this.first + list.size();
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).retainAll(collection);
            }
        }

        public Iterator iterator() {
            return new SubListIter(0);
        }

        public List subList(int n, int n2) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return new SubList(this.first + n, n + n2);
        }

        public ListIterator listIterator() {
            return new SubListIter(0);
        }

        public ListIterator listIterator(int n) {
            return new SubListIter(n);
        }

        public SubList(int n, int n2) {
            this.first = n;
            this.last = n2;
            this.expected = FastArrayList.this.list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int n, Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    Object object2 = this.get(arrayList).set(n, object);
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    return object2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).set(n, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] objectArray) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray(objectArray);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).toArray(objectArray);
            }
        }

        private List get(List list) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return list.subList(this.first, this.last);
        }

        private class SubListIter
        implements ListIterator {
            private List expected;
            private ListIterator iter;
            private int lastReturnedIndex = -1;

            public int nextIndex() {
                this.checkMod();
                return this.iter.nextIndex();
            }

            public int previousIndex() {
                this.checkMod();
                return this.iter.previousIndex();
            }

            private void checkMod() {
                if (((SubList)SubList.this).FastArrayList.this.list != this.expected) {
                    throw new ConcurrentModificationException();
                }
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().remove(this.lastReturnedIndex);
                SubList.this.last--;
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = this.get().listIterator(this.previousIndex());
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                this.checkMod();
                return this.iter.hasNext();
            }

            public boolean hasPrevious() {
                this.checkMod();
                return this.iter.hasPrevious();
            }

            public Object next() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.nextIndex();
                return this.iter.next();
            }

            public Object previous() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.previousIndex();
                return this.iter.previous();
            }

            public void add(Object object) {
                this.checkMod();
                int n = this.nextIndex();
                this.get().add(n, object);
                SubList.this.last++;
                this.iter = this.get().listIterator(n + 1);
                this.lastReturnedIndex = 1;
            }

            public void set(Object object) {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().set(this.lastReturnedIndex, object);
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = this.get().listIterator(this.previousIndex() + 1);
            }

            List get() {
                return SubList.this.get(this.expected);
            }

            public SubListIter(int n) {
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = SubList.this.get(this.expected).listIterator(n);
            }
        }
    }
}

